#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Genuary #03Mod01.fsh    by  Flopine   
//https://www.shadertoy.com/view/l3Kczh
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine

// Thanks to wsmind, leon, XT95, lsdlive, lamogui, 
// Coyhot, Alkama,YX, NuSan, slerpy, wwrighter 
// BigWings, FabriceNeyret and Blackle for teaching me

// Thanks LJ for giving me the spark :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  
// https://twitter.com/CookieDemoparty

// Genuary #02 : Exactly 42 lines of code


#define rot(a) mat2(cos(a), sin(a), -sin(a), cos(a))
#define noi(u) texture2D(texture0, u, 0.).x
vec3 SDF (vec3 p)
{
    p.yz*= rot(-atan(1./sqrt(2.))); p.xz*=rot(3.1415/4.);
    p.x += iTime*2.;
    float per = 2.5, d=0.; 
    vec2 id=floor(p.xz/per);
    if (noi(id*.1) > .5){
        p.xz = mod(p.xz, per)-per*0.5;
        d = length(p)-1.;
    }
    else{
        id=floor(p.xz/1.25);
        p.xz = mod(p.xz, 1.25)-0.625;
        d = length(p+vec3(0.,.4, 0.))-.5;
    }
    return vec3(min(d, abs(p.y+1.1)-.2), id);
}
vec3 gn (vec3 p){
    vec2 e = vec2(0.01, 0.);
    return normalize(SDF(p).x-vec3(SDF(p-e.xyy).x,SDF(p-e.yxy).x,SDF(p-e.yyx).x)); 
}
float AO(vec3 p, vec3 n, float e)
{return clamp(SDF(p+n*e).x/e,0., 1.);}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.y;
    bool hit=false; 
    vec3 ro=vec3(uv*6., -20.), rd=vec3(0.,0., 1.), col = vec3(0.), p=ro;
    for(float i=0.; i<40.; i++){
        float d = SDF(p).x;
        if (d<0.01) 
        {hit=true; break;}
        p += d*rd*.6;
    }
    if (hit){
        vec3 n = gn(p);
        col = mix(vec3(1.), vec3(.9,0.07,0.21), step(.7,noi(SDF(p).yz*.2))); 
        col *= (AO(p,n,0.15)+AO(p,n,0.35)+AO(p,n,0.5))/3.;
    }
    fragColor = vec4(sqrt(col),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

